<?php

namespace App\Core\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Company extends Model
{
    use SoftDeletes;

    protected $table = 'companies';
  
    protected $fillable = [
        // Basic Info
        'name',
        'legal_name',
        'registration_no',
        'tax_id',

        // Contact
        'email',
        'phone',
        'website',

        // Address
        'country',
        'state',
        'city',
        'address',
        'postal_code',

        // Branding
        'logo',
        'theme',

        // System Defaults
        'timezone',
        'date_format',

        'is_active',
    ];

    /**
     * The attributes that should be cast.
     */
    protected $casts = [
        'is_active' => 'boolean',
        'timezone' => 'string',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime',
    ];

    /**
     * Default attribute values.
     */
    protected $attributes = [
        'theme' => 'default',
        'timezone' => 'UTC',
        'date_format' => 'Y-m-d',
        'is_active' => true,
    ];
    
    // Relationships
    public function branches(): HasMany
    {
        return $this->hasMany(CompanyBranch::class);
    }

    public function subscriptions(): HasMany
    {
        return $this->hasMany(CompanySubscription::class);
    }

    public function limits(): HasMany
    {
        return $this->hasMany(CompanyLimit::class);
    }

    public function modules(): HasMany
    {
        return $this->hasMany(CompanyModule::class);
    }

    public function billingHistory(): HasMany
    {
        return $this->hasMany(CompanyBillingHistory::class);
    }

    public function customServices(): HasMany
    {
        return $this->hasMany(CompanyCustomService::class);
    }

    public function auditLogs(): HasMany
    {
        return $this->hasMany(CompanyAuditLog::class);
    }

    public function taxSettings(): HasMany
    {
        return $this->hasMany(CompanyTaxSetting::class);
    }
}
