<?php

namespace App\Core\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CompanyBillingHistoryItem extends Model
{
    protected $table = 'company_billing_history_items';

    protected $fillable = [
        'billing_id',
        'item_name',
        'amount',
        'currency',
        'quantity',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'quantity' => 'integer',
    ];

    public function billing(): BelongsTo
    {
        return $this->belongsTo(CompanyBillingHistory::class, 'billing_id');
    }
}
