<?php

use Illuminate\Support\Facades\Route;
use App\Core\Http\Controllers\CoreController;
use App\Core\Http\Controllers\BranchController;

Route::prefix('core')->group(function () { 
    // --- Test & Status ---
    Route::get('/test-core', [CoreController::class, 'testCore'])  ;
    Route::get('/status', [CoreController::class, 'status']);
    Route::get('/modules', [CoreController::class, 'modules']);

    // --- Company CRUD ---
    Route::get('/companies', [CoreController::class, 'index']);        // Get all companies
    Route::get('/companies/{id}', [CoreController::class, 'show']);    // Get single company
    Route::post('/companies', [CoreController::class, 'store']);       // Create new company
    Route::put('/companies/{id}', [CoreController::class, 'update']);  // Update company
    Route::delete('/delete_company/{id}', [CoreController::class, 'destroy']); // Delete company
    Route::get('/company_toggle/{id}', [CoreController::class, 'toggleActive']); // Toggle active status
    
    // --- Branch CRUD ---
    Route::get('/branches', [BranchController::class, 'index']);               // Get branches by company_id
    Route::post('/branches', [BranchController::class, 'store']);              // Create branch
    Route::put('/branches/{id}', [BranchController::class, 'update']);          // Update branch
    Route::delete('/branches/{id}', [BranchController::class, 'destroy']);      // Delete branch
    Route::patch('/branch_toggle/{id}', [BranchController::class, 'toggleActive']); // Toggle active status
    
});
           