<?php
// ============================================================================
// app/Core/Models/Permission.php
// ============================================================================
namespace App\Core\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Permission extends Model
{
    protected $table = 'user_permissions';

    protected $fillable = [
        'name',
        'module',
    ];

    public function roles(): BelongsToMany
    {
        return $this->belongsToMany(
            Role::class,
            'user_role_permissions',
            'permission_id',
            'role_id'
        );
    }
}
