<?php
// ============================================================================
// app/Core/Models/User.php
// ============================================================================
namespace App\Modules\AccessControl\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Str;

class User extends Authenticatable
{
    use HasApiTokens, SoftDeletes;

    protected $table = 'users';

    protected $fillable = [
        'uuid',
        'name',
        'username',
        'email',
        'password',
        'team_id',
        'is_active',
        'failed_logins',
        'locked_until',
        'two_factor_secret',
        'two_factor_recovery_codes',
        'avatar',
        'job_title',
        'timezone',
        'language',
    ];

    protected $hidden = [
        'password',
        'remember_token',
        'two_factor_secret',
        'two_factor_recovery_codes',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'locked_until' => 'datetime',
    ];

    /**
     * Boot function to auto-generate UUID.
     */
    protected static function boot()
    {
        parent::boot();

        
    }

    /**
     * Relationships
     */
    public function team(): BelongsTo
    {
        return $this->belongsTo(Team::class);
    }

    public function companies(): HasMany
    {
        return $this->hasMany(UserCompany::class);
    }

    public function attributes(): HasMany
    {
        return $this->hasMany(Attribute::class);
    }

    public function logins(): HasMany
    {
        return $this->hasMany(LoginHistory::class);
    }
}
