<?php

namespace App\Modules\Accounting\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class AccountingController extends Controller
{
    // Test route
    public function test()
    {
        return response()->json(['message' => 'Accounting module is working']);
    }

    // List all accounts (sample data)
    public function index()
    {
        $accounts = [
            ['id' => 1, 'name' => 'Cash', 'type' => 'Asset'],
            ['id' => 2, 'name' => 'Accounts Receivable', 'type' => 'Asset'],
            ['id' => 3, 'name' => 'Revenue', 'type' => 'Income'],
        ];

        return response()->json($accounts);
    }

    // Show single account
    public function show($id)
    {
        return response()->json([
            'id' => $id,
            'name' => 'Sample Account',
            'type' => 'Asset'
        ]);
    }

    // Create account
    public function store(Request $request)
    {
        $data = $request->only(['name', 'type']);
        $data['id'] = rand(100, 999); // sample ID
        return response()->json(['message' => 'Account created', 'account' => $data], 201);
    }

    // Update account
    public function update(Request $request, $id)
    {
        $data = $request->only(['name', 'type']);
        return response()->json(['message' => "Account {$id} updated", 'account' => $data]);
    }

    // Delete account
    public function destroy($id)
    {
        return response()->json(['message' => "Account {$id} deleted"]);
    }
}
