<?php

namespace App\Core\Models\Accounting;

use Illuminate\Database\Eloquent\Model;

class Account extends Model
{
    protected $table = 'accounts';

    protected $fillable = [
        'company_id',
        'branch_id',
        'name',
        'code',
        'type',
        'opening_balance',
        'parent_id',
        'level'
    ];

    public function parent()
    {
        return $this->belongsTo(Account::class, 'parent_id');
    }

    public function children()
    {
        return $this->hasMany(Account::class, 'parent_id');
    }

    public function ledger()
    {
        return $this->hasMany(AccountLedger::class);
    }

    public function journalEntries()
    {
        return $this->hasMany(JournalEntry::class);
    }
}
