<?php

namespace App\Core\Models\Accounting;

use Illuminate\Database\Eloquent\Model;

class VoucherLine extends Model
{
    protected $table = 'voucher_lines';

    protected $fillable = [
        'voucher_id',
        'account_id',
        'debit',
        'credit',
        'description'
    ];

    public function voucher()
    {
        return $this->belongsTo(Voucher::class);
    }

    public function account()
    {
        return $this->belongsTo(Account::class);
    }

    public function journalEntries()
    {
        return $this->hasMany(JournalEntry::class, 'voucher_line_id');
    }
}
