<?php

use Illuminate\Support\Facades\Route;
use App\Modules\Accounting\Http\Controllers\AccountingController;

Route::prefix('accounting')->group(function () {
    Route::get('/test', [AccountingController::class, 'test']); // test route
    Route::get('/accounts', [AccountingController::class, 'index']); // list accounts
    Route::post('/accounts', [AccountingController::class, 'store']); // create account
    Route::get('/accounts/{id}', [AccountingController::class, 'show']); // show account
    Route::put('/accounts/{id}', [AccountingController::class, 'update']); // update account
    Route::delete('/accounts/{id}', [AccountingController::class, 'destroy']); // delete account
});
