<?php

namespace App\Modules\CRM\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class CRMController extends Controller
{
    // Test route
    public function test()
    {
        return response()->json(['message' => 'CRM module is working']);
    }

    // List all customers (sample data)
    public function index()
    {
        $customers = [
            ['id' => 1, 'name' => 'John Doe', 'email' => 'john@example.com', 'status' => 'active'],
            ['id' => 2, 'name' => 'Jane Smith', 'email' => 'jane@example.com', 'status' => 'inactive'],
        ];

        return response()->json($customers);
    }

    // Show single customer
    public function show($id)
    {
        return response()->json([
            'id' => $id,
            'name' => 'Sample Customer',
            'email' => 'customer@example.com',
            'phone' => '123-456-7890',
            'status' => 'active',
            'leads' => [
                ['title' => 'Lead 1', 'status' => 'open'],
                ['title' => 'Lead 2', 'status' => 'closed']
            ]
        ]);
    }

    // Create customer
    public function store(Request $request)
    {
        $data = $request->only(['name', 'email', 'phone', 'status']);
        $data['id'] = rand(100, 999); // sample ID
        return response()->json(['message' => 'Customer created', 'customer' => $data], 201);
    }

    // Update customer
    public function update(Request $request, $id)
    {
        $data = $request->only(['name', 'email', 'phone', 'status']);
        return response()->json(['message' => "Customer {$id} updated", 'customer' => $data]);
    }

    // Delete customer
    public function destroy($id)
    {
        return response()->json(['message' => "Customer {$id} deleted"]);
    }
}
