<?php

namespace App\Modules\FileManager\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class FileManagerController extends Controller
{
    // Test route
    public function test()
    {
        return response()->json(['message' => 'FileManager module is working']);
    }

    // List all files (sample data)
    public function index()
    {
        $files = [
            ['id' => 1, 'name' => 'document.pdf', 'size' => '2MB', 'type' => 'pdf'],
            ['id' => 2, 'name' => 'image.jpg', 'size' => '500KB', 'type' => 'image'],
        ];

        return response()->json($files);
    }

    // Show single file
    public function show($id)
    {
        return response()->json([
            'id' => $id,
            'name' => 'samplefile.txt',
            'size' => '1MB',
            'type' => 'text',
            'path' => '/uploads/samplefile.txt'
        ]);
    }

    // Upload file
    public function store(Request $request)
    {
        $data = $request->only(['name', 'size', 'type', 'path']);
        $data['id'] = rand(100, 999); // sample ID
        return response()->json(['message' => 'File uploaded', 'file' => $data], 201);
    }

    // Update file info
    public function update(Request $request, $id)
    {
        $data = $request->only(['name', 'size', 'type', 'path']);
        return response()->json(['message' => "File {$id} updated", 'file' => $data]);
    }

    // Delete file
    public function destroy($id)
    {
        return response()->json(['message' => "File {$id} deleted"]);
    }
}
