<?php

use Illuminate\Support\Facades\Route;
use App\Modules\HRM\Http\Controllers\HRMController;

Route::prefix('hrm')->group(function () {
    Route::get('/test', [HRMController::class, 'test']); // test route
    Route::get('/employees', [HRMController::class, 'index']); // list all employees
    Route::get('/employees/{id}', [HRMController::class, 'show']); // show single employee
    Route::post('/employees', [HRMController::class, 'store']); // add employee
    Route::put('/employees/{id}', [HRMController::class, 'update']); // update employee
    Route::delete('/employees/{id}', [HRMController::class, 'destroy']); // delete employee
});
