<?php

use Illuminate\Support\Facades\Route;
use App\Modules\Installment\Http\Controllers\InstallmentController;

Route::prefix('installment')->group(function () {
    Route::get('/test', [InstallmentController::class, 'test']); // test route
    Route::get('/plans', [InstallmentController::class, 'index']); // list all plans
    Route::get('/plans/{id}', [InstallmentController::class, 'show']); // show single plan
    Route::post('/plans', [InstallmentController::class, 'store']); // create plan
    Route::put('/plans/{id}', [InstallmentController::class, 'update']); // update plan
    Route::delete('/plans/{id}', [InstallmentController::class, 'destroy']); // delete plan
});
