<?php

namespace App\Modules\Integration\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class IntegrationController extends Controller
{
    // Test route
    public function test()
    {
        return response()->json(['message' => 'Integration module is working']);
    }

    // List all integration services (sample data)
    public function index()
    {
        $services = [
            ['id' => 1, 'name' => 'Stripe', 'type' => 'payment', 'status' => 'active'],
            ['id' => 2, 'name' => 'Twilio', 'type' => 'sms', 'status' => 'inactive'],
        ];

        return response()->json($services);
    }

    // Show single integration
    public function show($id)
    {
        return response()->json([
            'id' => $id,
            'name' => 'Sample Service',
            'type' => 'payment',
            'status' => 'active',
            'config' => [
                'api_key' => 'xxxxxx',
                'endpoint' => 'https://api.example.com'
            ]
        ]);
    }

    // Add integration
    public function store(Request $request)
    {
        $data = $request->only(['name', 'type', 'status', 'config']);
        $data['id'] = rand(100, 999); // sample ID
        return response()->json(['message' => 'Integration added', 'integration' => $data], 201);
    }

    // Update integration
    public function update(Request $request, $id)
    {
        $data = $request->only(['name', 'type', 'status', 'config']);
        return response()->json(['message' => "Integration {$id} updated", 'integration' => $data]);
    }

    // Delete integration
    public function destroy($id)
    {
        return response()->json(['message' => "Integration {$id} deleted"]);
    }
}
