<?php

use Illuminate\Support\Facades\Route;
use App\Modules\Language\Http\Controllers\LanguageController;

Route::prefix('language')->group(function () {
    Route::get('/test', [LanguageController::class, 'test']); // test route
    Route::get('/', [LanguageController::class, 'index']); // list all languages
    Route::get('/{id}', [LanguageController::class, 'show']); // show single language
    Route::post('/', [LanguageController::class, 'store']); // add new language
    Route::put('/{id}', [LanguageController::class, 'update']); // update language
    Route::delete('/{id}', [LanguageController::class, 'destroy']); // delete language
});
