<?php

use Illuminate\Support\Facades\Route;
use App\Modules\ModuleManager\Http\Controllers\ModuleManagerController;

/*
|--------------------------------------------------------------------------
| Module Manager Routes
|--------------------------------------------------------------------------
| These routes handle module management (enable, disable, refresh, list).
| The prefix 'modules' means URLs will look like: /api/modules/...
|
*/

Route::prefix('modules')->group(function () {
    Route::get('/taaest', [ModuleManagerController::class, 'taaest']); // test route
    Route::get('/', [ModuleManagerController::class, 'index']);        // list all modules
    Route::post('/refresh', [ModuleManagerController::class, 'refresh']);
    Route::post('/{slug}/enable', [ModuleManagerController::class, 'enable']);
    Route::post('/{slug}/disable', [ModuleManagerController::class, 'disable']);
    Route::get('/{slug}', [ModuleManagerController::class, 'show']);   // must be last
});
