<?php

namespace App\Modules\RepairShop\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class RepairShopController extends Controller
{
    // Test route
    public function test()
    {
        return response()->json(['message' => 'RepairShop module is working']);
    }

    // List all repair orders (sample data)
    public function index()
    {
        $orders = [
            ['id' => 1, 'customer' => 'John Doe', 'item' => 'Laptop', 'status' => 'in progress', 'technician' => 'Alice'],
            ['id' => 2, 'customer' => 'Jane Smith', 'item' => 'Smartphone', 'status' => 'completed', 'technician' => 'Bob'],
        ];

        return response()->json($orders);
    }

    // Show single repair order
    public function show($id)
    {
        return response()->json([
            'id' => $id,
            'customer' => 'John Doe',
            'item' => 'Laptop',
            'status' => 'in progress',
            'technician' => 'Alice',
            'notes' => 'Screen replacement in progress',
            'history' => [
                ['date' => '2025-11-01', 'action' => 'Order received'],
                ['date' => '2025-11-02', 'action' => 'Diagnosis completed']
            ]
        ]);
    }

    // Create new repair order
    public function store(Request $request)
    {
        $data = $request->only(['customer', 'item', 'status', 'technician', 'notes']);
        $data['id'] = rand(100, 999); // sample ID
        return response()->json(['message' => 'Repair order created', 'order' => $data], 201);
    }

    // Update repair order
    public function update(Request $request, $id)
    {
        $data = $request->only(['customer', 'item', 'status', 'technician', 'notes']);
        return response()->json(['message' => "Repair order {$id} updated", 'order' => $data]);
    }

    // Delete repair order
    public function destroy($id)
    {
        return response()->json(['message' => "Repair order {$id} deleted"]);
    }
}
