<?php

namespace App\Modules\Settings\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class SettingsController extends Controller
{
    private $settings = [
        'site_name' => 'My Application',
        'timezone' => 'UTC',
        'maintenance_mode' => false,
    ];

    public function index()
    {
        return response()->json([
            'status' => 'success',
            'settings' => $this->settings
        ]);
    }

    public function update(Request $request)
    {
        $data = $request->only(array_keys($this->settings));

        // Update settings (this is just an example; normally you'd save to DB)
        foreach ($data as $key => $value) {
            $this->settings[$key] = $value;
        }

        return response()->json([
            'status' => 'success',
            'message' => 'Settings updated successfully',
            'settings' => $this->settings
        ]);
    }

    public function test()
    {
        return response()->json(['message' => 'Settings module is working!']);
    }
}
