<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {

    public function up(): void
    {
        /*------------------------------------------
         | 1️⃣ Categories
        ------------------------------------------*/
        Schema::create('categories', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->unsignedBigInteger('parent_id')->nullable();
            $table->timestampsTz();
        });

        /*------------------------------------------
         | 2️⃣ Brands
        ------------------------------------------*/
        Schema::create('brands', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->timestampsTz();
        });

        /*------------------------------------------
         | 3️⃣ Units (PCS, KG, LTR, HOUR)
        ------------------------------------------*/
        Schema::create('units', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->string('short_code')->nullable();
            $table->timestampsTz();
        });

        /*------------------------------------------
         | 4️⃣ Products (Master Item)
        ------------------------------------------*/
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->unsignedBigInteger('category_id')->nullable();
            $table->unsignedBigInteger('brand_id')->nullable();
            $table->unsignedBigInteger('unit_id')->nullable();
            $table->enum('type', ['stockable','service','digital'])->default('stockable');
            $table->timestampsTz();
            $table->softDeletesTz();
        });

        /*------------------------------------------
         | 5️⃣ Product SKUs (Sellable Variants)
        ------------------------------------------*/
        Schema::create('product_skus', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('product_id')->nullable();
            $table->string('sku')->nullable();
            $table->boolean('is_serialized')->default(false);
            $table->boolean('is_expirable')->default(false);
            $table->decimal('cost_price', 15, 2)->nullable();
            $table->decimal('sale_price', 15, 2)->nullable();
            $table->timestampsTz();
        });

        /*------------------------------------------
         | 6️⃣ Product Attributes (Definitions)
        ------------------------------------------*/
        Schema::create('product_attributes', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->enum('type', ['string','number','select'])->default('string');
            $table->boolean('is_required')->default(false);
            $table->timestampsTz();
        });

        /*------------------------------------------
         | 7️⃣ Attribute Values (for products or SKUs)
        ------------------------------------------*/
        Schema::create('attribute_values', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('product_id')->nullable(); // Product-level attribute
            $table->unsignedBigInteger('sku_id')->nullable();     // SKU-level attribute
            $table->unsignedBigInteger('attribute_id')->nullable();
            $table->string('value')->nullable();
            $table->timestampsTz();
        });

        /*------------------------------------------
         | 8️⃣ Stock Ledger (Movement-based)
        ------------------------------------------*/
        Schema::create('stock_ledger', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('sku_id')->nullable();
            $table->decimal('qty', 15, 2)->default(0);
            $table->decimal('cost_price', 15, 2)->nullable();
            $table->enum('type', ['OPEN','IN','OUT','ADJUST'])->default('OPEN');
            $table->jsonb('meta')->nullable();
            $table->timestampsTz();
        });

        /*------------------------------------------
         | 9️⃣ Product Serials / IMEI / Unique IDs
        ------------------------------------------*/
        Schema::create('product_serials', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('sku_id')->nullable();
            $table->string('serial_number')->nullable();
            $table->boolean('is_sold')->default(false);
            $table->date('warranty_until')->nullable();
            $table->timestampsTz();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('product_serials');
        Schema::dropIfExists('stock_ledger');
        Schema::dropIfExists('attribute_values');
        Schema::dropIfExists('product_attributes');
        Schema::dropIfExists('product_skus');
        Schema::dropIfExists('products');
        Schema::dropIfExists('units');
        Schema::dropIfExists('brands');
        Schema::dropIfExists('categories');
    }
};
