<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {

        // ------------------------------
        // Invoices
        // ------------------------------
        Schema::create('invoices', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique();

            // Removed FKs
            $table->unsignedBigInteger('company_id')->nullable();
            $table->unsignedBigInteger('branch_id')->nullable();
            $table->unsignedBigInteger('customer_id')->nullable();

            $table->string('invoice_no')->unique();
            $table->date('invoice_date');
            $table->date('due_date')->nullable();

            $table->decimal('total_amount', 15, 2)->default(0);
            $table->decimal('paid_amount', 15, 2)->default(0);
            $table->decimal('balance_amount', 15, 2)->default(0);

            $table->enum('status', ['draft','sent','paid','partial','cancelled'])
                  ->default('draft');

            $table->boolean('is_synced')->default(false);
            $table->timestampsTz();
            $table->softDeletesTz();
        });

        // ------------------------------
        // Invoice Items
        // ------------------------------
        Schema::create('invoice_items', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique();

            // Removed FKs
            $table->unsignedBigInteger('invoice_id')->nullable();
            $table->unsignedBigInteger('product_id')->nullable();

            $table->decimal('quantity', 15, 2)->default(0);
            $table->decimal('unit_price', 15, 2)->default(0);
            $table->decimal('total', 15, 2)->default(0);

            $table->jsonb('attributes')->nullable();

            $table->timestampsTz();
        });

        // ------------------------------
        // Invoice Payments
        // ------------------------------
        Schema::create('invoice_payments', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique();

            // Removed FKs
            $table->unsignedBigInteger('invoice_id')->nullable();
            $table->unsignedBigInteger('company_id')->nullable();
            $table->unsignedBigInteger('branch_id')->nullable();

            $table->decimal('amount', 15, 2)->default(0);
            $table->enum('payment_method', ['cash','bank','card','online','cheque'])
                  ->default('cash');

            $table->date('payment_date');
            $table->string('reference')->nullable();

            $table->boolean('is_synced')->default(false);
            $table->timestampsTz();
        });

    }

    public function down(): void {
        Schema::dropIfExists('invoice_payments');
        Schema::dropIfExists('invoice_items');
        Schema::dropIfExists('invoices');
    }
};
