<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {

        // ----------------------
        // 1️⃣ FBR Clients / Taxpayers
        // ----------------------
        Schema::create('fbr_clients', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique();

            $table->unsignedBigInteger('company_id'); // removed FK
            $table->string('name');
            $table->string('ntn')->nullable();
            $table->string('strn')->nullable();
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->string('country', 100)->default('Pakistan');
            $table->string('address')->nullable();

            $table->timestampsTz();
        });

        // ----------------------
        // 2️⃣ FBR Invoices
        // ----------------------
        Schema::create('fbr_invoices', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique();

            $table->unsignedBigInteger('company_id'); // removed FK
            $table->unsignedBigInteger('branch_id')->nullable(); // removed FK
            $table->unsignedBigInteger('client_id'); // removed FK

            $table->string('invoice_number')->unique();
            $table->date('invoice_date');
            $table->decimal('total_amount', 15,2)->default(0);
            $table->decimal('total_tax', 15,2)->default(0);
            $table->enum('currency', ['PKR','USD','EUR','GBP'])->default('PKR');
            $table->enum('status', ['draft','submitted','approved','rejected','cancelled'])->default('draft');

            $table->timestampsTz();
        });

        // ----------------------
        // 3️⃣ FBR Invoice Items
        // ----------------------
        Schema::create('fbr_invoice_items', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('invoice_id'); // removed FK
            $table->string('description');
            $table->decimal('quantity', 15,2)->default(1);
            $table->decimal('unit_price', 15,2)->default(0);
            $table->decimal('tax_rate', 5,2)->default(0);
            $table->decimal('tax_amount', 15,2)->default(0);
            $table->decimal('total', 15,2)->default(0);
            $table->string('item_code')->nullable();

            $table->timestampsTz();
        });

        // ----------------------
        // 4️⃣ FBR Responses / Logs
        // ----------------------
        Schema::create('fbr_logs', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('invoice_id')->nullable(); // removed FK
            $table->string('endpoint');
            $table->text('request_payload')->nullable();
            $table->text('response_payload')->nullable();
            $table->enum('status', ['success','error','pending'])->default('pending');
            $table->timestampsTz();
        });

        // ----------------------
        // 5️⃣ Tax Rates / International Support
        // ----------------------
        Schema::create('fbr_tax_rates', function (Blueprint $table) {
            $table->id();
            $table->string('country')->default('Pakistan');
            $table->string('tax_name');
            $table->decimal('tax_rate', 5,2)->default(0);
            $table->timestampsTz();
        });

        // ----------------------
        // 6️⃣ Settings / API Keys
        // ----------------------
        Schema::create('fbr_settings', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('company_id'); // removed FK
            $table->string('api_base_url')->nullable();
            $table->string('api_key')->nullable();
            $table->string('client_id')->nullable();
            $table->string('client_secret')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestampsTz();
        });
    }

    public function down(): void {
        Schema::dropIfExists('fbr_settings');
        Schema::dropIfExists('fbr_tax_rates');
        Schema::dropIfExists('fbr_logs');
        Schema::dropIfExists('fbr_invoice_items');
        Schema::dropIfExists('fbr_invoices');
        Schema::dropIfExists('fbr_clients');
    }
};
