<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // ---------------------
        // Hotels
        // ---------------------
        Schema::create('hotels', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('address')->nullable();
            $table->string('city')->nullable();
            $table->string('country')->nullable();
            $table->string('phone')->nullable();
            $table->string('email')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestampsTz();
        });

        // ---------------------
        // Rooms
        // ---------------------
        Schema::create('rooms', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('hotel_id'); // removed FK
            $table->string('room_number');
            $table->enum('type', ['single', 'double', 'suite'])->default('single');
            $table->decimal('price', 15, 2)->default(0);
            $table->boolean('is_available')->default(true);
            $table->timestampsTz();
        });

        // ---------------------
        // Guests
        // ---------------------
        Schema::create('guests', function (Blueprint $table) {
            $table->id();
            $table->string('first_name');
            $table->string('last_name')->nullable();
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->timestampsTz();
        });

        // ---------------------
        // Reservations
        // ---------------------
        Schema::create('reservations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('hotel_id'); // removed FK
            $table->unsignedBigInteger('room_id'); // removed FK
            $table->unsignedBigInteger('guest_id'); // removed FK
            $table->date('check_in');
            $table->date('check_out');
            $table->decimal('total_amount', 15, 2)->default(0);
            $table->enum('status', ['booked', 'checked_in', 'checked_out', 'cancelled'])->default('booked');
            $table->timestampsTz();
        });

        // ---------------------
        // Payments
        // ---------------------
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('reservation_id'); // removed FK
            $table->decimal('amount', 15, 2);
            $table->string('payment_method')->nullable(); // cash, card, online
            $table->enum('status', ['pending', 'completed', 'failed'])->default('pending');
            $table->timestampsTz();
        });

        // ---------------------
        // Staff linked to Users
        // ---------------------
        Schema::create('staff', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('hotel_id'); // removed FK
            $table->unsignedBigInteger('user_id');  // removed FK
            $table->string('role')->nullable(); // receptionist, manager, housekeeper
            $table->boolean('is_active')->default(true);
            $table->timestampsTz();
        });

        // ---------------------
        // Hotel Managers (optional, multi-hotel user)
        // ---------------------
        Schema::create('hotel_managers', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('hotel_id'); // removed FK
            $table->unsignedBigInteger('user_id');  // removed FK
            $table->timestampsTz();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('hotel_managers');
        Schema::dropIfExists('staff');
        Schema::dropIfExists('payments');
        Schema::dropIfExists('reservations');
        Schema::dropIfExists('guests');
        Schema::dropIfExists('rooms');
        Schema::dropIfExists('hotels');
    }
};
